-- invisible helper - no localization?

-- PhysX GUI for Distance Joint

plugin helper nvSpring
name:"nvSpring"
category:"NVIDIA PhysX"
classID:#(0x294f1fb0, 0xbe0488a)
invisible:true
extends:dummy replaceui:true
(
	parameters jointspec rollout: px_panel_connection
	(
		body0           type:#node      ui:body0_ui
		body1           type:#node      ui:body1_ui

		--aptype			type:#index		default: 1
		--globalAnchor    type:#point3    default:[0, 0, 0]
		--globalAxis      type:#point3    default:[1, 0, 0]
		
		breakable       type:#boolean   ui:breakable_ui   default: false
		maxForce        type:#float     ui:maxForce_ui    default: 100.0
		maxTorque       type:#float     ui:maxTorque_ui   default: 10.0
	)
	
	rollout px_panel_connection "Connection" rolledUp:false  category:1
	(
		label         lbl1_ui       "Parent: "           align:#left across:3
		pickbutton    body0_ui      "undefined"          align:#left toolTip:"Specify Parent" autoDisplay: true
		button		  rembody0_ui	"x"					 align:#right toolTip:"Remove Parent"
		label         lbl2_ui       "Child: "            align:#left across:3
		pickbutton    body1_ui      "undefined"          align:#left toolTip:"Specify Child" autoDisplay: true
		button		  rembody1_ui	"x"					 align:#right toolTip:"Remove Child"
		
		checkbox      breakable_ui  "Breakable"         checked:false
		label         maxForce_lb   "Max Force"         align:#left  across:2 offset:[20, 0]
		spinner       maxForce_ui   ""                  align:#right range:[0.01,PxMaxValue,0.01] type:#float width:50 
		label         maxTorque_lb  "Max Torque"        align:#left  across:2 offset:[20, 0]
		spinner       maxTorque_ui  ""                  align:#right range:[0.01,PxMaxValue,0.01] type:#float width:50
	    
	    --on breakable_ui  changed value do   (UpdateD6Param "breakable" (breakable as string) )
	    --on maxForce_ui  changed value do   (UpdateD6Param "maxForce"  (maxForce as string) )
	    --on maxTorque_ui changed value do   (UpdateD6Param "maxTorque" (maxTorque as string) )
	    
		on rembody0_ui pressed do
		(
			PxStopSimulation()
			body0_ui.object = undefined;
		)
		
		on body0_ui picked obj do
		(
			PxStopSimulation()
			if (obj != undefined) then
			(
				if (obj == undefined) then
				(
				)
				else if isgroupmember(obj) then
				(
					obj = PxGetRootParent obj
					body0_ui.object = obj
				)
				if obj == body1 then
				(
					messagebox "The two nodes connecting to Constraint should be different."
					body0_ui.object = undefined
				)
				else if (superclassof(obj) == helper) and (not isgrouphead(obj)) then
				(
					format "obj = %, and old = %\n" obj.name body0.name
					messagebox "Helper node can not be set as part of PhysX Constraint."
					body0_ui.object = undefined
				)
				else if PxIsDynamicRB(obj) then
				(
					body0_ui.object = obj
					pxCurrentNode.parent = obj
				)
				else if PxIsKinematicRB(obj) then
				(
					if body1 == undefined then
					(
						body0_ui.object = obj
						pxCurrentNode.parent = obj
					)
					else if PxIsKinematicRB(body1) then
					(
						format "obj = %, body1 = %\n" obj.name body1.name
						info = "It is not valid that two Kinematic Rigid Bodies connect to a constraint."
						messagebox info
						body0_ui.object = undefined
					)
					else
					(
						body0_ui.object = obj
						pxCurrentNode.parent = obj
					)
				)
				else if PxIsStaticRB(obj) then
				(
					info = obj.name + " is not a Dyanmic or Kinematic Rigid Body."
					messagebox info
					body0_ui.object = undefined
				)
				else 
				(
					local strStream = StringStream("")
					format nvpxText.TXT_CONSTRAINT_QUERY_APPLYRBMTO1 obj.name to:strStream
					info = nvpxText.TXT_CONSTRAINT_QUERY_MUSTBERB + (strStream as string)
					yes  = queryBox info
					if yes then
					(
						PxMakeDynamicRB obj
						body0_ui.object = obj
						pxCurrentNode.parent = obj
					)
					else
					(
						body0_ui.object = undefined
					)
				)
			)
		)

		on rembody1_ui pressed do
		(
			PxStopSimulation()
			body1_ui.object = undefined;
		)
		
		on body1_ui picked obj do
		(
			PxStopSimulation()
			
			if (obj != undefined) then
			(
				if (obj == undefined) then
				(
				)
				else if isgroupmember(obj) then
				(
					obj = PxGetRootParent obj
					body1_ui.object = obj
				)
				if obj == body0 then
				(
					messagebox "The two nodes connecting to Constraint should be different."
					body1_ui.object = undefined
				)
				else if (superclassof(obj) == helper) and (not isgrouphead(obj)) then
				(
					format "obj = %, and old = %\n" obj.name body0.name
					messagebox "Helper node can not be set as part of PhysX Constraint."
					body1_ui.object = undefined
				)
				else if PxIsDynamicRB(obj) then
				(
					body1_ui.object = obj
				)
				else if PxIsKinematicRB(obj) then
				(
					if body0 == undefined then
					(
						body1_ui.object = obj
					)
					else if PxIsKinematicRB(body0) then
					(
						info = "It is not valid that two Kinematic Rigid Bodies connect to a constraint."
						messagebox info
						body1_ui.object = undefined
					)
					else
					(
						body1_ui.object = obj
					)
				)
				else if PxIsStaticRB(obj) then
				(
					info = obj.name + " is not a Dyanmic or Kinematic Rigid Body."
					messagebox info
					body1_ui.object = undefined
				)
				else 
				(
					local strStream = StringStream("")
					format nvpxText.TXT_CONSTRAINT_QUERY_APPLYRBMTO1 obj.name to:strStream
					info = nvpxText.TXT_CONSTRAINT_QUERY_MUSTBERB + (strStream as string)
					yes  = queryBox info
					if yes then
					(
						PxMakeDynamicRB obj
						body1_ui.object = obj
					)
					else
					(
						body1_ui.object = undefined
					)
				)
			)
		)
	)

	parameters jointspec rollout: px_panel_spring
	(
		minDistance        type:#float      ui:minDistance_ui            default:0
		maxDistance        type:#float      ui:maxDistance_ui            default:10
		enableSpring       type:#boolean    ui:enableSpring_ui           default: true
		spring             type:#float      ui:spring_ui                 default:1
		damping            type:#float      ui:damping_ui                default:0.3
		targetValue        type:#float      ui:targetValue_ui            default:0
	)
	
	rollout px_panel_spring "Spring" rolledUp:false  category:2
	(
		group "Defaults"
		(
		label     lbl_sp01          "Min Distance"         align:#left  across:2
		spinner   minDistance_ui    ""                     align:#right range:[0, PxMaxValue,0.01] type:#float width:60 
		label     lbl_sp02          "Max Distance"         align:#left  across:2
		spinner   maxDistance_ui    ""                     align:#right range:[0, PxMaxValue,0.01] type:#float width:60 
		checkbox  enableSpring_ui   "Spring"
		label     lbl_sp03          "Spring"               align:#left  across:2 offset:[10, 0]
		spinner   spring_ui         ""                     align:#right range:[0, PxMaxValue,0.01] type:#float width:60 
		label     lbl_sp04          "Damping"              align:#left  across:2 offset:[10, 0]
		spinner   damping_ui        ""                     align:#right range:[0, PxMaxValue,0.01] type:#float width:60 
		label     lbl_sp05          "Target Value"         align:#left  across:2 offset:[10, 0]
		spinner   targetValue_ui    ""                     align:#right range:[0, PxMaxValue,0.01] type:#float width:60 
		)
	)

	tool create
	(
		on mousepoint click do
		case click of
		(
			1: 
			(
				nodeTM.translation = worldpoint;
				delegate.boxsize = [3, 3, 3];
				#stop
			)
		)
	)
)